/*------------------------------------------------------------------------------*
 * File Name: Tabs.cpp		 													*
 * Creation: GJL 11/11/03														*
 * Purpose: OriginC Source CPP file containing sample code for the Tabs Dialog	*
 * Builder example.																*
 * Copyright (c) OriginLab Corp.	2003, 2004, 2005, 2006, 2007				*
 * 																				*
 * Modification Log:															*
 *------------------------------------------------------------------------------*/
 
#include <Origin.h>
#include <Dialog.h>
#include "TabsRes.h"

// Base Tab class
class Tab : public PropertyPage
{
public:

	// Constructor for base Tab class
	Tab(int nID) : PropertyPage(nID) { }

	// Event handler when Tab becomes active (inherited by all Tab derived classes)
	BOOL OnActiveTab()
	{
		int iTabNum = GetID() - IDD_FIRSTTAB + 1;
		printf("Tab%d Active\n", iTabNum);
		return TRUE;		
	}
};

// Derived Tab class for Tab1
class Tab1 : public Tab
{
public:

	// Constructor for Tab1 class
	Tab1(int nID) : Tab(nID) { }

	// InitMsgMap function setting up event handler map for Tab1
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitTab)
		PAGE_ON_ACTIVE(OnActiveTab)
		ON_BN_CLICKED(IDC_BUTTON1, OnClickToggleButton)
	EVENTS_END
	
	// Event handlers for Tab1
	BOOL OnInitTab()
	{
		out_str("Tab1 Init");
		m_btnCheckBox = GetItem(IDC_CHECK1);
		m_btnCheckBox.Check = 1;
		return TRUE;
	}

	BOOL OnClickToggleButton(Control ctrl)
	{
		out_str("Click Toggle Button");
		m_btnCheckBox.Check = mod(m_btnCheckBox.Check + 1, 2);
		return TRUE;
	}

	// Data member controls on Tab1
	Button m_btnCheckBox;
};

// Derived Tab class for Tab2
class Tab2 : public Tab
{
public:

	// Constructor for Tab2 class
	Tab2(int nID) : Tab(nID) { }

	// InitMsgMap function setting up event handler map for Tab2
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitTab)
		PAGE_ON_ACTIVE(OnActiveTab)
		ON_BN_CLICKED(IDC_BUTTON2, OnClickUpperCaseButton)
	EVENTS_END
	
	// Event handlers for Tab2
	BOOL OnInitTab()
	{
		out_str("Tab2 Init");
		m_ebxText = GetItem(IDC_EDIT1);
		m_ebxText.Text = "Enter text to upper case";
		return TRUE;
	}

	BOOL OnClickUpperCaseButton(Control ctrl)
	{
		out_str("Click Upper Case Button");
		m_ebxText.Text.MakeUpper();
		return TRUE;
	}

	// Data member controls on Tab2
	Edit m_ebxText;
};

// Derived Tab class for Tab3
class Tab3 : public Tab
{
public:

	// Constructor for Tab3 class
	Tab3(int nID) : Tab(nID) { }

	// InitMsgMap function setting up event handler map for Tab3
	EVENTS_BEGIN
		PAGE_ON_INIT(OnInitTab)
		PAGE_ON_ACTIVE(OnActiveTab)
		ON_BN_CLICKED(IDC_BUTTON3, OnClickOutputButton)
	EVENTS_END

	// Event handlers for Tab3
	BOOL OnInitTab()
	{
		out_str("Tab3 Init");
		m_cmbxStooges = GetItem(IDC_COMBO1);
		m_cmbxStooges.SetCurSel(0);
		return TRUE;
	}

	BOOL OnClickOutputButton(Control ctrl)
	{
		out_str("Click Output Button");
		string str;
		m_cmbxStooges.GetLBText(m_cmbxStooges.GetCurSel() ,str);
		str.Format("You selected %s.",str);
		str.Write(WRITE_MESSAGE_BOX);
		return TRUE;
	}

	// Data member controls on Tab3
	ComboBox m_cmbxStooges;
};


// Tab place holder class
class TabSheet : public PropertySheet
{
public:

	// Constructor for PropertySheet class
	TabSheet()
	{
		m_Tab1.SetID(IDD_FIRSTTAB);
		m_Tab2.SetID(IDD_SECONDTAB);
		m_Tab3.SetID(IDD_THIRDTAB);
		AddPage(m_Tab1);
		AddPage(m_Tab2);
		AddPage(m_Tab3);
	}

	// Initialize message maps for each Tab
	void InitMaps()
	{
		m_Tab1.InitMsgMap();
		m_Tab2.InitMsgMap();
		m_Tab3.InitMsgMap();
	}

	// Data members of PropertySheet are Tab objects
	Tab1 m_Tab1;
	Tab2 m_Tab2;
	Tab3 m_Tab3;
};



// Main dialog class
class TabbedDialog : public Dialog
{
public:

	// Constructor for main Dialog
	TabbedDialog(int ID) : Dialog(ID, "Tabs.DLL")
	{
		SetResizingStyle(RESIZE_DEPENDENCY_DOMINANT_DIALOG);
	}

	// Function to launch main Dialog
	int TabsDoModal(HWND hWnd)
	{
		InitMsgMap();
		return DoModal(hWnd, DLG_MODAL_WITH_KEY);
	}

	// InitMsgMap function setting up event handlers for main Dialog
	EVENTS_BEGIN
		PAGE_ON_INIT(Init)
		PAGE_ON_OK(OnClickOk)
		PAGE_ON_CANCEL(OnClickCancel)
	EVENTS_END

	// Event handlers for main Dialog
	BOOL Init()
	{
		out_str("Tabbed Dialog Init");
		m_Sheet.Create(IDC_TAB_PLACEHOLDER, *this);
		m_Sheet.InitMaps();
		return TRUE;
	}

	BOOL OnClickOk()
	{
		out_str("Click OK Button");
		return TRUE;
	}

	BOOL OnClickCancel()
	{
		out_str("Click Cancel Button");
		return TRUE;
	}

	// Data member of main Dialog is PropertySheet (place holder)
	TabSheet m_Sheet;
};

// Function to launch main Tabs dialog
void Tabs()
{
	TabbedDialog tdlg(IDD_TABS);
	tdlg.TabsDoModal(GetWindow());
}